package com.ethon.ui;

import java.awt.Graphics;
import java.awt.image.BufferedImage;

import javax.swing.JPanel;

import com.ethon.tools.CoordTransfer;

/**
 * 
 * @author ethonchan	ethonchan@gmail.com
 *
 */
public class ImagePanel extends JPanel{
	private static final long serialVersionUID = 1L;
	DataField parent;
	private BufferedImage image;
	
	ImagePanel(DataField parent){
		this.parent=parent;
		image=DataField.tempImg;
	}
	
	/**
	 * JPanelķˢpanelʱԶ
	 */
	protected void paintComponent(Graphics g){
		super.paintComponent(g);
		int slen=CoordTransfer.getLenOfImagePanel(parent);
		int xs=(parent.getWidth()-slen)/2;
		g.drawImage(image, xs, 0, slen, slen, this);
		
		g.dispose();
	}
	
	void update(BufferedImage image){
		this.image=image;
		
		repaint();
	}
}
